/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/

`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_add_sub ( result, cout, overflow,
        add_sub, cin, dataa, datab ) ;

parameter lpm_type = "lpm_add_sub" ;
parameter lpm_width = 1 ; 
parameter lpm_rep    = "UNSIGNED" ; 
parameter lpm_direction  = "UNUSED" ; 
parameter polar_result   = "NORMAL" ; 
parameter polar_cout     = "NORMAL" ; 
parameter polar_overflow = "NORMAL" ; 
parameter polar_add_sub  = "NORMAL" ; 
parameter polar_cin      = "NORMAL" ; 
parameter polar_dataa    = "NORMAL" ; 
parameter polar_datab    = "NORMAL" ;

  input  [lpm_width-1:0] dataa, datab ;
  input  add_sub, cin ;
  output [lpm_width-1:0] result ;
  output cout, overflow ;

  // INTERNALS
  reg  [lpm_width-1:0] result ;
  reg  cout ;
  reg  overflow ;
  reg  [lpm_width-1:0] pdataa ;
  reg  [lpm_width-1:0] pdatab ;
  reg  pcin, pcout, padd_sub ;
  reg  [lpm_width-2:0] tmp_a, tmp_b;
  integer i, dataa_int, datab_int, result_int, compare, borrow;
  
  // If input is not connected
  pullup P1 ( add_sub) ;
  pulldown P2 ( cin) ;

  initial
  begin
	  // if lpm_direction != UNUSED, assume input pin add_sub is not used.
      if(lpm_direction === "ADD")
	  	padd_sub = 1;
      else if(lpm_direction === "SUB")
		padd_sub = 0;
  end

  always @(padd_sub)
	  if((padd_sub && lpm_direction === "SUB") 
		|| (padd_sub == 1'b0 && lpm_direction === "ADD"))
		$display("%t:Error! Conflict between LPM_DIRECTION property and pin add_sub.", $time);

  always @( cin or dataa or datab or add_sub )
  begin
      // input ports changed according to the polar specification
      pdataa <= #1 (polar_dataa == "INVERT")?~dataa:dataa;
      pdatab <= #1 (polar_datab == "INVERT")?~datab:datab;
      pcin   <= #1 (polar_cin == "INVERT")?~cin:cin ;
      // if lpm_direction is UNUSED, assume the input pin add_sub is used.
	  if(lpm_direction === "UNUSED")
      	padd_sub <= #1 (polar_add_sub == "INVERT")?~add_sub:add_sub ;

  end

  always @( pcin or pdataa or pdatab or padd_sub )
  begin
	borrow = pcin?0:1 ;
	// cout is the same for both signed and unsign representation.	
	if(padd_sub == 1)
	begin
		{cout,result} = pdataa + pdatab + pcin ;
		overflow = cout ;
	end
	else
	begin
		// subtraction 
		{overflow, result} = pdataa - pdatab - borrow ;
		cout = (pdataa >= datab)?1:0 ;
	end
	
	if(lpm_rep == "SIGNED")
	begin
		// convert to negative integer
		if(pdataa[lpm_width-1] == 1)
		begin
			for(i = 0; i < lpm_width - 1; i = i + 1)
				tmp_a[i] = pdataa[i] ^ 1;
			dataa_int = (tmp_a + 1) * (-1) ;
		end
		else dataa_int = pdataa;

		// convert to negative integer
		if(pdatab[lpm_width-1] == 1)
		begin
			for(i = 0; i < lpm_width - 1; i = i + 1)
				tmp_b[i] = pdatab[i] ^ 1;
			datab_int = (tmp_b + 1) * (-1);
		end
		else datab_int = pdatab;

		// perform the addtion or subtraction operation
		if(padd_sub == 1)
			result_int = dataa_int + datab_int + pcin ;
		else
			result_int = dataa_int - datab_int - borrow ;
		result = result_int ;

		// set the overflow
		compare = 1 << (lpm_width -1);
		if((result_int > (compare - 1)) || (result_int < (-1)*(compare)))
			overflow = 1;
		else
			overflow = 0;
	end

	result = (polar_result == "INVERT")?~result:result ;
 	cout = (polar_cout == "INVERT")?~cout:cout ;
 	overflow = (polar_overflow == "INVERT")?~overflow:overflow ;
  end


endmodule // LPM_ADD_SUB
`ifdef SYNTH
`else
`endcelldefine
`endif
 
